<?php
session_start();
include 'conexao.php';

// Buscar alunos admitidos ordenados pela média decrescente
$alunos_admitidos = $conn->query("SELECT * FROM novos_alunos WHERE obs = 'Admitido' ORDER BY curso, media DESC, idade ASC")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Ver Admissão Geral</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: #f4f6f9;
      margin: 0;
      padding: 20px;
    }
    .topbar {
      background: #003366;
      height: 55px;
      line-height: 55px;
      color: white;
      padding: 0 20px;
      position: fixed;
      left: 0;
      right: 0;
      top: 0;
      z-index: 1000;
    }
    h2 {
      margin-top: 80px;
      color: #003366;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      background: white;
      margin-top: 10px;
      font-size: 15px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 8px;
      text-align: center;
    }
    th {
      background: #003366;
      color: white;
    }
    .vermelho {
      color: red;
      font-weight: bold;
    }
    .verde {
      color: green;
      font-weight: bold;
    }
    .controls {
      margin-top: 20px;
    }
    .controls label {
      font-weight: bold;
      margin-right: 10px;
    }
    .controls input {
      padding: 5px;
      margin-right: 10px;
      width: 100px;
    }
    .controls button {
      padding: 8px 15px;
      font-weight: bold;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      transition: 0.3s;
    }
    .controls button:hover {
      background-color: #0056b3;
    }
  </style>
</head>
<body>

<div class="topbar">
  <strong>SISMAG - Ver Admissão Geral</strong>
</div>

<h2>Lista de Alunos Admitidos</h2>

<form method="post" action="distribuir_turmas.php" class="controls">
  <label>Vagas para E.INF:</label>
  <input type="number" name="vagas_einf" value="80" required>
  <label>Vagas para E.PRIM:</label>
  <input type="number" name="vagas_eprim" value="160" required>
  <button type="submit"><i class="fas fa-share"></i> Distribuir Turmas</button>
  <button onclick="window.print(); return false;"><i class="fas fa-print"></i> Imprimir Lista</button>
  <button type="button" onclick="window.open('imprimir_lista.php', '_blank')"><i class="fas fa-file-pdf"></i> PDF Pronto</button>
</form>

<table>
  <thead>
    <tr>
      <th>Nº</th>
      <th style="width: 30%;">Nome</th>
      <th>Idade</th>
      <th>Curso</th>
      <th>L. Portuguesa</th>
      <th>Matemática</th>
      <th>Média</th>
      <th>Observação</th>
    </tr>
  </thead>
  <tbody>
    <?php $n = 1; foreach ($alunos_admitidos as $al): ?>
      <tr>
        <td><?= $n++ ?></td>
        <td style="text-align: left;"><?= htmlspecialchars($al['nome']) ?></td>
        <td><?= $al['idade'] ?></td>
        <td><?= $al['curso'] ?></td>
        <td style="color:<?= $al['lp'] < 10 ? 'red':'green' ?>;"><?= $al['lp'] ?></td>
        <td style="color:<?= $al['mat'] < 10 ? 'red':'green' ?>;"><?= $al['mat'] ?></td>
        <td class="<?= $al['media'] < 10 ? 'vermelho' : 'verde' ?>"><?= $al['media'] ?></td>
        <td class="<?= $al['obs']==='Admitido' ? 'verde' : 'vermelho' ?>"><?= $al['obs'] ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

</body>
</html>










